#!/bin/sh

APXS=${APXS:=/usr/local/bin/apxs}

APINCDIR=`$APXS -q exp_includedir`

if test -f $APINCDIR/util_fcgi.h; then
    # server has util_fcgi
    UTILFCGI=""
    EXTRAINC=""
    if ! diff $APINCDIR/util_fcgi.h for_24/util_fcgi.h; then
        echo "util_fcgi.h is different!"
        exit 1
    fi
else
    UTILFCGI="for_24/util_fcgi.c"
    EXTRAINC="-Ifor_24"
fi

# compile+link
CMD="$APXS -c $EXTRAINC mod_authnz_fcgi.c $UTILFCGI newapis.c"
echo $CMD
if $CMD; then
    :
else
    exit 1
fi

# install
echo ""
echo ""
echo "Run this command to install the module, as root or via sudo if necessary:"
echo ""
echo ""
echo $APXS -i mod_authnz_fcgi.la
echo ""
echo ""
