#include "httpd.h"

#if 0 /* get from util_fcgi.h now */
#define AP_FCGI_VERSION_1 1

#define AP_FCGI_BEGIN_REQUEST       1
#define AP_FCGI_ABORT_REQUEST       2
#define AP_FCGI_END_REQUEST         3
#define AP_FCGI_PARAMS              4
#define AP_FCGI_STDIN               5
#define AP_FCGI_STDOUT              6
#define AP_FCGI_STDERR              7
#define AP_FCGI_DATA                8
#define AP_FCGI_GET_VALUES          9
#define AP_FCGI_GET_VALUES_RESULT  10
#define AP_FCGI_UNKNOWN_TYPE       11
#define AP_FCGI_MAXTYPE (AP_FCGI_UNKNOWN_TYPE)

typedef struct {
    unsigned char version;
    unsigned char type;
    unsigned char requestIdB1;
    unsigned char requestIdB0;
    unsigned char contentLengthB1;
    unsigned char contentLengthB0;
    unsigned char paddingLength;
    unsigned char reserved;
} ap_fcgi_header;

#define AP_FCGI_MAX_CONTENT_LEN 65535

#define AP_FCGI_HDR_VERSION_OFFSET         0
#define AP_FCGI_HDR_TYPE_OFFSET            1
#define AP_FCGI_HDR_REQUEST_ID_B1_OFFSET   2
#define AP_FCGI_HDR_REQUEST_ID_B0_OFFSET   3
#define AP_FCGI_HDR_CONTENT_LEN_B1_OFFSET  4
#define AP_FCGI_HDR_CONTENT_LEN_B0_OFFSET  5
#define AP_FCGI_HDR_PADDING_LEN_OFFSET     6
#define AP_FCGI_HDR_RESERVED_OFFSET        7

#define AP_FCGI_BRB_ROLEB1_OFFSET       0
#define AP_FCGI_BRB_ROLEB0_OFFSET       1
#define AP_FCGI_BRB_FLAGS_OFFSET        2
#define AP_FCGI_BRB_RESERVED0_OFFSET    3
#define AP_FCGI_BRB_RESERVED1_OFFSET    4
#define AP_FCGI_BRB_RESERVED2_OFFSET    5
#define AP_FCGI_BRB_RESERVED3_OFFSET    6
#define AP_FCGI_BRB_RESERVED4_OFFSET    7

/*
 * Number of bytes in a fcgi_header.  Future versions of the protocol
 * will not reduce this number.
 */
#define AP_FCGI_HEADER_LEN  8

/*
 * Mask for flags component of ap_fcgi_begin_request_body
 */
#define AP_FCGI_KEEP_CONN  1

/*
 * Values for role component of ap_fcgi_begin_request_body
 */
#define AP_FCGI_RESPONDER  1
#define AP_FCGI_AUTHORIZER 2
#define AP_FCGI_FILTER     3

/*
 * String forms, for the value of the FCGI_ROLE envvar
 */
#define AP_FCGI_RESPONDER_STR   "RESPONDER"
#define AP_FCGI_AUTHORIZER_STR  "AUTHORIZER"
#define AP_FCGI_FILTER_STR      "FILTER"

typedef struct {
    unsigned char roleB1;
    unsigned char roleB0;
    unsigned char flags;
    unsigned char reserved[5];
} ap_fcgi_begin_request_body;

/*
 * FastCGI implementations that implement the AUTHORIZER role
 * for Apache httpd and allow the application to participate in
 * any of the Apache httpd AAA phases typically set the variable
 * FCGI_APACHE_ROLE to one of these strings to indicate the
 * specific AAA phase.
 */
#define AP_FCGI_APACHE_ROLE_AUTHENTICATOR_STR  "AUTHENTICATOR"
#define AP_FCGI_APACHE_ROLE_AUTHORIZER_STR     "AUTHORIZER"
#define AP_FCGI_APACHE_ROLE_ACCESS_CHECKER_STR "ACCESS_CHECKER"

/** @} */
/*
 * The below 3 functions serve to map the FCGI structs
 * back and forth between an 8 byte array. We do this to avoid
 * any potential padding issues when we send or read these
 * structures.
 *
 * NOTE: These have specific internal knowledge of the
 *       layout of the fcgi_header and fcgi_begin_request_body
 *       structs!
 */
AP_DECLARE(void) ap_fcgi_header_to_array(ap_fcgi_header *h,
                                         unsigned char a[]);

AP_DECLARE(void) ap_fcgi_header_from_array(ap_fcgi_header *h,
                                           unsigned char a[]);

AP_DECLARE(void) ap_fcgi_header_fields_from_array(unsigned char *version,
                                                  unsigned char *type,
                                                  apr_uint16_t *request_id,
                                                  apr_uint16_t *content_len,
                                                  unsigned char *padding_len,
                                                  unsigned char a[]);

AP_DECLARE(void) ap_fcgi_begin_request_body_to_array(ap_fcgi_begin_request_body *h,
                                                     unsigned char a[]);

/*
 * Fill in a fastcgi request header with the following type, request id,
 * content length, and padding length.
 *
 * The header array must be at least AP_FCGI_HEADER_LEN bytes long.
 */
AP_DECLARE(void) ap_fcgi_fill_in_header(ap_fcgi_header *header,
                                        unsigned char type,
                                        apr_uint16_t request_id,
                                        apr_uint16_t content_len,
                                        unsigned char padding_len);

/*
 * Fill in a FastCGI begin request body with the specified role and
 * flags.
 */
AP_DECLARE(void) ap_fcgi_fill_in_request_body(ap_fcgi_begin_request_body *brb,
                                              int role,
                                              unsigned char flags);

/*
 * Compute the buffer size needed to encode the environment table.
 * Specify an optional maxlen.  If provided and the size needed for
 * the xxx
 */
AP_DECLARE(apr_size_t) ap_fcgi_encoded_env_len(apr_table_t *env,
                                               apr_size_t maxlen,
                                               int *next_elem);

AP_DECLARE(apr_status_t) ap_fcgi_encode_env(request_rec *r,
                                            apr_table_t *env,
                                            void *buffer,
                                            apr_size_t buflen,
                                            int *starting_elem);

#endif

/**
 * Processing flags for ap_log_data() et al
 *
 * AP_LOG_DATA_DEFAULT - default formatting
 * AP_LOG_DATA_SHOW_OFFSET - prefix each line with hex offset from the start
 * of the buffer
 */
#define AP_LOG_DATA_DEFAULT       0
#define AP_LOG_DATA_SHOW_OFFSET   1

/**
 * ap_log_data() - log buffers which are not related to a particular request
 * or connection.
 * @param file The file in which this function is called
 * @param line The line number on which this function is called
 * @param module_index The module_index of the module logging this buffer
 * @param level The log level
 * @param s The server on which we are logging
 * @param label A label for the buffer, to be logged preceding the buffer
 * @param data The buffer to be logged
 * @param len The length of the buffer
 * @param flags Special processing flags like AP_LOG_DATA_SHOW_OFFSET
 * @note Use APLOG_MARK to fill out file, line, and module_index
 * @note If a request_rec is available, use that with ap_log_rerror()
 * in preference to calling this function.  Otherwise, if a conn_rec is
 * available, use that with ap_log_cerror() in preference to calling
 * this function.
 */
AP_DECLARE(void) ap_log_data(const char *file, int line, int module_index,
                             int level, const server_rec *s, const char *label,
                             const char *data, apr_size_t len, unsigned int flags);

/**
 * ap_log_rdata() - log buffers which are related to a particular request.
 * @param file The file in which this function is called
 * @param line The line number on which this function is called
 * @param module_index The module_index of the module logging this buffer
 * @param level The log level
 * @param r The request which we are logging for
 * @param label A label for the buffer, to be logged preceding the buffer
 * @param data The buffer to be logged
 * @param len The length of the buffer
 * @param flags Special processing flags like AP_LOG_DATA_SHOW_OFFSET
 * @note Use APLOG_MARK to fill out file, line, and module_index
 * @note If a request_rec is available, use that with ap_log_rerror()
 * in preference to calling this function.  Otherwise, if a conn_rec is
 * available, use that with ap_log_cerror() in preference to calling
 * this function.
 */
AP_DECLARE(void) ap_log_rdata(const char *file, int line, int module_index,
                              int level, const request_rec *r, const char *label,
                              const char *data, apr_size_t len, unsigned int flags);

/**
 * ap_log_cdata() - log buffers which are related to a particular connection.
 * @param file The file in which this function is called
 * @param line The line number on which this function is called
 * @param module_index The module_index of the module logging this buffer
 * @param level The log level
 * @param c The connection which we are logging for
 * @param label A label for the buffer, to be logged preceding the buffer
 * @param data The buffer to be logged
 * @param len The length of the buffer
 * @param flags Special processing flags like AP_LOG_DATA_SHOW_OFFSET
 * @note Use APLOG_MARK to fill out file, line, and module_index
 * @note If a request_rec is available, use that with ap_log_rerror()
 * in preference to calling this function.  Otherwise, if a conn_rec is
 * available, use that with ap_log_cerror() in preference to calling
 * this function.
 */
AP_DECLARE(void) ap_log_cdata(const char *file, int line, int module_index,
                              int level, const conn_rec *c, const char *label,
                              const char *data, apr_size_t len, unsigned int flags);

